//
//  GMSQueueViewController.m
//  GMS Sample
//
//  Created by Arkady on 8/1/13.
//  Copyright (c) 2013 Genesys. All rights reserved.
//

#import "GMSQueueViewController.h"
#import "GMSAppDelegate.h"
#import "GMSRequestViewController.h"
#import "GMSUtil.h"

@interface GMSQueueViewController ()

@end

@implementation GMSQueueViewController

NSTimer *timer;

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self refreshQueue:nil];
    timer = [NSTimer scheduledTimerWithTimeInterval:5.0
                                             target:self
                                           selector:@selector(refreshQueue:)
                                           userInfo:nil
                                            repeats:YES];
}

- (void) viewWillDisappear:(BOOL)animated
{
    [timer invalidate];
    [super viewWillDisappear:animated];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidUnload {
    [self setPositionLabel:nil];
    [self setEtaLabel:nil];
    [self setThresholdLabel:nil];
    [self setTotalLabel:nil];
    [super viewDidUnload];
}
- (IBAction)refreshQueue:(id)sender {

    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    
    NSString *path = [[@"/1/service" stringByAppendingPathComponent:appDelegate.serviceID] stringByAppendingPathComponent:@"check-queue-position"];
    
    void (^completionBlock)(NSDictionary *responseDict) = ^(NSDictionary *responseDict){
        if ([responseDict isKindOfClass:[NSDictionary class]]) {
            _positionLabel.text = [GMSUtil stringFromNumericValue:responseDict[@"_position"]];
            _etaLabel.text = [GMSUtil stringFromNumericValue:responseDict[@"_eta"]];
            _thresholdLabel.text = [GMSUtil stringFromNumericValue:responseDict[@"_agent_ready_threshold_passed"]];
            _totalLabel.text = [GMSUtil stringFromNumericValue:responseDict[@"_total_waiting"]];
        }
    };
    [GMSUtil submitRequestWithPath:path method:@"POST" params:nil headers:nil completionBlock:completionBlock];
}
@end
